@// code originally from phillips appnote 10254
@ 
@                        Assembler Directives
@ 
               .section asm_code,"ax"   @ New Code section
               @ CODE32                @ ARM code
               .extern __main         @ main not defined
                                     @ in this section
               .global _start          @ global symbol
                                     @ referenced in
                                     @ ivt.s
@ 
_start:
               @ Enable interrupts
               
               MSR cpsr_c,#0x13
               
               @ Set SP for Supervisor mode. Depending upon
               @ the stack the application needs this value
               @ needs to be set.
               
               LDR SP,=0x40001000
               
               @ Setting up SP for IRQ mode. Change mode to
               @ IRQ before setting SP_irq and then
               @ move back again to Supervisor mode
               
               MRS R0, CPSR
               BIC R1, R0,#0x1F
               ORR R1, R1,#0x12
               MSR cpsr_c, R1
               LDR SP, =0x40002000
               MSR cpsr_c, R0
               
               @ Jump to C code
               
               LDR lr, =__main
               MOV pc, lr
