/*
 *	Handy functions for controlling LPC2106 PWM channels.
 *	Author: Bruce McKenney, BMC Consulting, Selkirk, NY
 */
#ifndef	_PWM_H_
#define	_PWM_H_	1

/*
 * pwm_init(nticks, tickcycles)
 * One-time setup for "nticks" steps each "tickcycles" long.
 * E.g. 2ms servo, 100 steps: pwm_init(100,PWM_MSEC(2)/100);
 *
 * pwm_chan_init(chan,initduty)
 * Starts a particular PWM pin at some initial duty (0 is often fine).
 * E.g. P0.7, servo initially centered: pwm_chan_init(PWM2,75);
 *
 * pwm_set(chan,duty)
 * Changes duty cycle for channel (duty is range [0..nticks]).
 * E.g. As above, move servo far-left (1ms): pwm_set(PWM2,50);
 */

#define	PWM2	2			/* P0.7 */
#define	PWM4	4			/* P0.8 */
#define	PWM6	6			/* P0.9 */

extern void pwm_init(unsigned int nticks, unsigned int tickcycles);
extern void pwm_chan_init(unsigned int chan, unsigned int initduty);
extern void pwm_set(unsigned int chan, unsigned int duty);

/*
 * These don't belong here, but they're really handy for
 * building arguments for the above.
 */
#define	PWM_PCLK			60000000L		/* pclk==CPU (see VPBDIV) */
#define	PWM_PCLK_PER_USEC	(PWM_PCLK/1000000L)
#define	PWM_PCLK_PER_MSEC	(PWM_PCLK_PER_USEC*1000)	/* 1000 us */
#define	PWM_PCLK_PER_SEC	(PWM_PCLK_PER_MSEC*1000)	/* 1000 ms */
#define	PWM_USEC(_us)		((_us)*PWM_PCLK_PER_USEC)
#define	PWM_MSEC(_ms)		((_ms)*PWM_PCLK_PER_MSEC)
#define	PWM_SEC(_s)			((_s)*PWM_PCLK_PER_SEC)

#endif	/* _PWM_H_ */
