@// code originally from phillips appnote 10254
@ 
@                        Assembler Directives
@ 
               .section asm_code,"ax"   @ New Code section
               @ CODE32                @ ARM code
               .extern __main         @ main not defined
                                     @ in this section
               .global _start          @ global symbol
                                     @ referenced in
                                     @ ivt.s
@ 
_start:
               @ Set SP for Supervisor mode. Depending upon
               @ the stack the application needs this value
               @ needs to be set.               
               @ stack is already set by bootloader
               @ but if this point is entered by any
               @ other means than reset, the stack pointer
               @ needs to be set explicity

               @ LDR SP,=0x40001000
               
               @ Setting up SP for IRQ and FIQ mode.
               @ Change mode before setting each one
               @ move back again to Supervisor mode
               @ Each interrupt has its own link
               @ register, stack pointer and program
               @ counter The stack pointers must be
               @ initialized for interrupts to be
               @ used later.
               
               @ setup for fiq and irq interrupt stacks to run
               @ below current stack by 1000.
               mov r0, sp         @ copy current stack pointer
               sub r0, r0, #1000  @ make irq stack pointer
               sub r1, r0, #1000  @ make fiq stack pointer
               msr cpsr_c, #0x12  @ switch to irq mode
               mov sp, r0         @ set irq stack pointer
               msr cpsr_c, #0x11  @ fiq mode
               mov sp, r1         @ set fiq stack pointer
               msr cpsr_c, #0x13  @ supervisor mode F,I enabled
               
               @ Jump to C code

               LDR lr, =__main
               MOV pc, lr
