/* code originally from phillips appnote 10254 */

/* *********************************************************
               Function declarations
  ********************************************************* */
void IRQHandler(void);
void feed(void);
void Initialize(void);

/**********************************************************
                  Header files
 **********************************************************/
#include "LPC210x.h"
#include <string.h>

// serial port
#define RDR  0x01
#define THRE 0x20

char rx_query(void)
{
	return UART0_LSR & RDR;
}

char tx_query(void)
{
	return UART0_LSR & THRE;
}

void tx(char c)
{
	UART0_THR = c;
}

char rx(void)
{
	return UART0_RBR;
}

void tx_str(char *s)  // send a string
{
	while(*s)
		if (tx_query())
			tx(*s++);
}

/**********************************************************
                       MAIN
**********************************************************/

void __main (void)
{
	char *x = (char *)0, *y = (char *)0x1000;

  /* Initialize the system */
  Initialize();
  
  /* Start timer */
// Interrupts not working yet so this code is commented out for now
//  TIMER1_TCR=0x1;

// For testing library inclusion  
//  memcpy(x,y,100);

  // test banner
  tx_str("\n\rTest echo\n\r");
  // echo for main loop
  while(1)
  	if (rx_query() && tx_query())  // received and ready to send
  		tx(rx());  // get and send
}

/**********************************************************
                      Initialize
**********************************************************/
extern const char _text_start, _text_end;
extern char _data_start, _data_end;
#define PLOCK 0x400

void Initialize(void)
{
//  memcpy(&_data_start, &_text_end, &_data_end - &_data_start);

  // set io pins for leds red off, yellow off, green on
  IODIR |= 0x03800000;  // 23-25 are outputs
  IOSET = 0x00800000;   // green led on
  IOCLR = 0x03000000;   // red and yellow off
 
  /*
   * Initialize PLL (Configured for a 10MHz crystal) to
   * boost processor clock to 60MHz
   */

  /* Setting Multiplier and divider values */
  PLLCFG=0x25;
  feed();
  
  /* Enabling the PLL */
  PLLCON=0x1;
  feed();
  
  /* Wait for the PLL to lock to set frequency */
  while(!(PLLSTAT & PLOCK)){}
  
  /* Connect the PLL as the clock source */
  PLLCON=0x3;
  feed();
  
 /*
  * Enabling MAM and setting number of clocks used for
  * Flash memory fetch
  */
  MAMCR=0x2;
  MAMTIM=0x4;
  
 /*
  * Setting peripheral Clock (pclk) to System
  * Clock (cclk)
  */
  VPBDIV=0x1;
  
  /* Initialize GPIO */
//  IODIR=0xFFFF;
//  IOSET=0xFFFF;
  
  /* Initialize Timer 1 */
  TIMER1_TCR=0x0;
  TIMER1_TC=0x0;
  TIMER1_PR=0x0;
  TIMER1_PC=0x0;
  
  /* End user has to fill in the match value */
  TIMER1_MR0=0x123456;
  
  /* Reset and interrupt on match */
  TIMER1_MCR=0x3;
  
  /* Initialize VIC */
  VICIntSelect=0x0; /* Timer 1 selected as IRQ */
  VICIntEnable= 0x20; /* Timer 1 interrupt enabled */
  VICVectCntl0= 0x25;
  
  /* Address of the ISR */
  VICVectAddr0=(unsigned long)IRQHandler;
  
  
  /* initialize serial port */
  // initialize UART
  PINSEL0 = 5;      // enable UART0 in/out
  UART0_FCR = 0x7;   // enable and reset fifos
  UART0_LCR = 0x83;	// 8 bits; enable divisor latches
  UART0_DLL = 0x87;  // LSB divider for 60mhz to be 9600x16
  UART0_DLM = 0x01;  // MSB
  UART0_LCR = 0x3;   // disable divisor latches
}

/**********************************************************
                       Timer 1 ISR
 **********************************************************/
void __attribute__((interrupt)) IRQHandler(void)
{
/*
 * The Interrupt Service Routine code will come here. The
 * interrupt needs to be cleared in Timer1 and a write must
 * be performed on the VIC Vector Address Register to
 * update the VIC priority hardware. Here the user could
 * blink a few LEDs or toggle some port pins as an
 * indication of being in the ISR
 */
  IOSET = 0x01000000;   // yellow led on
  TIMER1_IR=0x1;
  VICVectAddr=0xff;
}

void feed(void)
{
  PLLFEED=0xAA;
  PLLFEED=0x55;
}
