@  code originally from phillips appnote 10254
@ 
@               Assembler Directives
@ 
               .section .interp,"ax"  @ alocateable and executable New Code section
                               @ compiler option : CODE32          @ ARM code
               .extern start   @ start symbol not
                               @ defined in this
                               @ section
Entry:                          @ Defines entry point
@ 
               LDR PC, =_start
               LDR PC, Undefined_Addr
               LDR PC, SWI_Addr
               LDR PC, Prefetch_Addr
               LDR PC, Abort_Addr

@ At 0x14 the user should insert a signature (checksum).
@ This signature enables the bootloader to determine if
@ there is valid user code in the Flash. Currently most of
@ the Flash programming tools (debuggers and ISP utility)
@ have this feature builtin so the end user need not worry
@ about it. If the tool does not provide this feature then
@ the value has to be computed manually and has to be
@ inserted at 0x14. Details on computation of checksum
@ could be found in the Flash programming chapter in the
@ LPC2104/5/6 User Manual.

               NOP                       @ for code to be
               LDR PC, [PC, #0xFFFFFFF0] @ load irq vector from vic
               LDR PC, FIQ_Addr
Undefined_Addr: .word Undefined_Handler
SWI_Addr:       .word SWI_Handler
Prefetch_Addr:  .word Prefetch_Handler
Abort_Addr:     .word Abort_Handler
FIQ_Addr:       .word FIQ_Handler

@ 
@ Exception Handlers
@ 
@ The following dummy handlers do not do anything useful in
@ this example. They are set up here for completeness.

Undefined_Handler:
               B         Undefined_Handler
SWI_Handler:
               B         SWI_Handler
Prefetch_Handler:
               B         Prefetch_Handler
Abort_Handler:
               B         Abort_Handler
FIQ_Handler:
               B         FIQ_Handler
END:
