; Vector Init routine with an interrupt

IPR             equ     $FFFB
COPCTL          equ     $0F30
PLLCR           equ     $0FA0
PLLDB           equ     $0FA1
PLLSR           equ     $0FA2
TESTR           equ     $0FA3
CLKOSR          equ     $0FA4
ISOCTL          equ     $0FA5
WAIT_LOCK       equ     $4000
PLLCR_INIT      equ     $0081
PLLDB_INIT      equ     $F013
PLLCR_PROCEED   equ     $0082
PLLSR_INIT      equ     $0040
_32BIT_COMPARES equ     $0100
MR15            equ     $3F

        jmp     dspinit         ; skip to init
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     myint1          ; Timer D Channel 0
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec
        jmp     dummyvec

dspinit:

        bfset   #_32BIT_COMPARES,omr    ; 32 bit compares
        move    #-1,x0
        move    x0,m01                  ; set the m reg to linear addressing
        move    hws,la                  ; clear the hardware stack
        move    hws,la
                                        ; init registers
        move    #0,r1
        move    r1,x:IPR                ; (0xfffb)
        move    r1,x:COPCTL
                                        ; initialize compiler environment
CALLMAIN:
                                        ; setup stack
        move    #STACK,r0               ; get stack start address
        nop
        move    r0,x:<mr15              ; set frame pointer to main stack top
        move    r0,sp                   ; set stack pointer too
        move    #0,r1
        move    r1,x:(r0)
                                        ; setup the PLL (phase locked loop)
        move    #pllcr_init,x:pllcr     ; set lock detector on
                                        ; and choose core clock
        move    #plldb_init,x:plldb     ; set to max freq
        move    #wait_lock,x0           ; set x0 with timeout value

pll_test_lock:                          ; loop until PLL is locked
                                        ; or we reach timeout limit
        decw    x0                      ; decrement our timeout value
        tstw    x0                      ; test for zero
        beq     pll_timeout             ; if timed-out, proceed anyway
        brclr   #pllsr_init,x:pllsr,pll_test_lock

pll_timeout:
                                        ; pll locked
        move    #pllcr_proceed,x:pllcr  ; set lock detector on,
                                        ; choose PLL clock
        move    x:pllsr,x0              ; clear pending clkgen interrupts
        move    x0,x:pllsr

; setup exception handler and interrupt levels

        move    #M56805_int_Addr,r1      ; exception handler address
        ; push    r1                    ; establish exception handler
        lea     (SP)+
        move    R1,x:(SP)
        bfset   #$0100,sr               ; enable all levels of interrupts
        bfclr   #$0200,sr               ; allow IPL 0 interrupts

        move    #0,x0                   ; clear X.RAM
        move    #2047,r2
        move    #0,r1
        do      r2,endclear
        move    x0,x:(r1)+
        nop
endclear:

; call main()

        jsr             Fmain            ; call the users program
        debug
        rts

dummyvec:
        nop
        rti

M56805_int_Addr:
        nop
        rti

