/*+++

 srf04.c
 Example program for the IsoPod (see http://www.newmicros.com)

 Sonar measurement (TC0 = Trigger, TC1 = Echo). Tested with
 Devantech SRF04 Ultrasonic Range Finder. Adjust accuracy/range by changing
 D4E prescalar and final result conversion factor.

 Peter F Gray (petegray@ieee.org)
 13Feb03

---*/

#include "scdefs.h"

/* SCI definitions */
#define SCI0BR  0x0F00
#define SCI0CR  0x0F01
#define SCI0SR  0x0F02
#define SCI0DR  0x0F03

/* TIMER definitions */
#define D47 0x0D47
#define D4A 0x0D4A
#define D4D 0x0D4D
#define D4E 0x0D4E
#define D4F 0x0D4F

/* general purpose I/O routines */
outsci (a,b)
int  *a;
unsigned char *b;
{
  int status;
  while (*b) {
    do status = *SCI0SR; while ((status&0xC000)!=0xC000);
    *a = *b;
    *b++;
  }
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

outscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
  *a = *b;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

void outdec (chan, val)
unsigned int *chan;
unsigned int val;
{
  unsigned int u,t;
  unsigned char c;
  t = 10000;
  do {
    u = 0;
    while (val>=t) { val -= t; u++; }
    c = '0' + u;
    outscichar (chan,&c);
    t /= 10;
  } while (t>0);
}

main ()
{
  unsigned int result;

  *SCI0BR = 260;                                /* set up SCI */
  *SCI0CR = 12;                                 /* 9600, N81 */

  outsci (SCI0DR,"\15\nSCI Module Ready.\15\n");

  while (1) {                                   /* loop forever */

    *D47 = 0x000D;                              /* Trigger (TMRC0) high */
    *D4D = 0;                                   /* zero TMRC1 CNTR      */
    *D47 = 0x0005;                              /* Trigger (TMRC0) low  */
    *D4F = 0x0080;                              /* falling edge capture */
    *D4E = 0x7880;                              /* IP/16 TMRC1 input    */

    result = *D4A;                              /* get capture value */
    outdec (SCI0DR,result);
    outsci (SCI0DR," = ");
    result /= 367;                              /* convert to inches */
    outdec (SCI0DR,result);
    outsci (SCI0DR," in.");
    outsci (SCI0DR,"\15");
  }
}

