/*+++

 sonar.c
 Example program for the IsoPod (see http://www.newmicros.com)

 Sonar measurement (PA7 = INIT, TC0 = ECHO). Tested with
 Polaroid 6500 (#61507) Sonar (aka ultrasonic ranger).

 Peter F Gray (petegray@ieee.org)
 2Feb03

---*/

#include "scdefs.h"

/* SCI definitions */
#define SCI0BR  0x0F00
#define SCI0CR  0x0F01
#define SCI0SR  0x0F02
#define SCI0DR  0x0F03

/* TIMER definitions */
#define D40 0x0D40
#define D41 0x0D41
#define D42 0x0D42
#define D43 0x0D43
#define D45 0x0D45
#define D46 0x0D46
#define D47 0x0D47

/* GPIO registers */
#define PAPUR   0x0FB0
#define PADR    0x0FB1
#define PADDR   0x0FB2
#define PAPER   0x0FB3
#define PAIAR   0x0FB4
#define PAIENR  0x0FB5
#define PAIPOLR 0x0FB6
#define PAIPR   0x0FB7
#define PAIESR  0x0FB8

/* general purpose I/O routines */
outsci (a,b)
int  *a;
unsigned char *b;
{
  int status;
  while (*b) {
    do status = *SCI0SR; while ((status&0xC000)!=0xC000);
    *a = *b;
    *b++;
  }
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

outscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
  *a = *b;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

void outdec (chan, val)
unsigned int *chan;
unsigned int val;
{
  unsigned int u,t;
  unsigned char c;
  t = 10000;
  do {
    u = 0;
    while (val>=t) { val -= t; u++; }
    c = '0' + u;
    outscichar (chan,&c);
    t /= 10;
  } while (t>0);
}

delay()
{
  unsigned int i;
    for (i=0; i<30000; i++);
}

main ()
{
  int result, status;

  *SCI0BR = 260;                                /* set up SCI */
  *SCI0CR = 12;                                 /* 9600, N81 */

  outsci (SCI0DR,"\15\nSCI Module Ready.\15\n");

  *PAIAR = 0;                                   /* set up GPIO */
  *PAIENR = 0;
  *PAIPOLR = 0;
  *PAIESR = 0;
  *PAPER = 0x007F;
  *PADDR = 0x0080;
  *PAPUR = 0x00FF;

  while (1) {                                   /* loop forever */
    *PADR |= 0x0080;                            /* set INIT high */
    for (result=0; result<100; result++);       /* pause for ringing */
    *D45 = 0;                                   /* TMRC0 CNTR = 0 */
    *D40 = 0;                                   /* TMRC0 CMP1 = 0 */
    *D41 = 0;                                   /* TMRC0 CMP2 = 0 */
    *D43 = 0;                                   /* TMRC0 LOAD = 0 */
    *D46 = 0x7E00;                              /* CTRL rising prim, sec high */
    *D47 = 0x0280;                              /* SCR load rising edge */
                                                /* wait for ECHO */
    do status = *D47; while ((status & 0x0800) != 0x0800);
    *PADR &= 0x007F;                            /* set INIT low */
    result = *D42;                              /* get capture value */
    outdec (SCI0DR,result);
    outsci (SCI0DR," = ");
    result /= 46;                               /* convert to inches */
    outdec (SCI0DR,result);
    outsci (SCI0DR," in.");
    outsci (SCI0DR,"\15\n");
    for (result=0; result<9; result++) delay(); /* pause */
  }
}

