/*+++

 quad.c
 Example program for the IsoPod (see http://www.newmicros.com)
 Also tested on NMIN-0803-Mini.

 Quadrature encoder directly controls position of servo, encoder values
 displayed via SCI (e.g. hyperterm).

 Quad A =PHASEA0, Quad B = PHASEB0, PWMA0 = Servo signal.
 Tested with CUI Stack Quad Encoder and Hitec HS-322/422 servo.

 Peter F Gray (petegray@ieee.org)
 23Feb03

---*/

#include "scdefs.h"

/* SCI definitions */
#define SCI0BR  0x0F00
#define SCI0CR  0x0F01
#define SCI0SR  0x0F02
#define SCI0DR  0x0F03

/* PWM definitions */
#define FA1     0x0FA1
#define E00     0x0E00
#define E03     0x0E03
#define E05     0x0E05
#define E06     0x0E06
#define E07     0x0E07
#define E0D     0x0E0D
#define E0E     0x0E0E
#define E0F     0x0E0F

/* Quad registers */
#define E47     0x0E47
#define E48     0x0E48

/* servo left and right max values */
#define MAXLEFT 0x02E4
#define MAXRIGHT 0x0B9A
/* servo incremental movement value */
#define BIGINC 5

/* global var - servo position */
int p;

outsci (a,b)
int  *a;
unsigned char *b;
{
  int status;
  while (*b) {
    do status = *SCI0SR; while ((status&0xC000)!=0xC000);
    *a = *b;
    *b++;
  }
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

outscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
  *a = *b;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

outscihex (a,b)
int *a;
int b;
{
  int  c,r,neg;
  char t[5];
  c = 3; neg = 0;
  if ((b&0x8000)==0x8000) {                   /* test for sign bit */
    neg = 1;
    b &= 0x7FFF;                              /* remove if found */
    }
  while (c>=0) { 
    r = b&0x000F;
    if (r < 10)
      t[c] = '0'+r;
    else
      t[c] = 'A'+((r)-10);
    b >>= 4;
    c--;
    if (neg&&(c==0)) b |= 0x0008;             /* put sign bit back */
  }
  t[4] = 0;
  outsci (a,t); 
}

/* move servo to new position */
moveto (newpos)
int newpos;
{
  int status;
  *E06 = newpos;
  status = *E00;
  *E00 = 0x00C3;
}

/* main program */
main ()
{
  int r, pmid;
  *SCI0BR = 130;                /* set up SCI registers */
  *SCI0CR = 12;                 /* 9600, 8N1 */

  *FA1 = 0xF413;                /* set up PWM registers */
  *E03 = 0x8000;
  *E05 = 0x61A8;
  *E0D = 0;
  *E0E = 0;
  *E0F = 0x000E;
  outsci (SCI0DR,"\15\nSystem Ready\15\n");

                                /* calculate starting (mid) point */
  p = pmid = (MAXLEFT + MAXRIGHT) / 2;
  moveto (p);

  while (1) {                   /* loop forever */
    r = *E47;                   /* read quad position (upper) */
    outscihex (SCI0DR,r);
    r = *E48;                   /* read quad position (lower) */
    outscihex (SCI0DR,r);
    outsci (SCI0DR,"\15");
    p = pmid + (r*BIGINC);      /* calculate new servo position */
                                /* and adjust if out-of-bounds  */

    if (p>MAXRIGHT) {p = MAXRIGHT; *E48 = (MAXRIGHT-pmid)/BIGINC;}
    if (p<MAXLEFT) {p = MAXLEFT; *E48 = (MAXLEFT-pmid)/BIGINC;}

    moveto (p);                 /* move servo to new position */
  }
}

