/*+++

 prox.c
 Example program for the IsoPod (see http://www.newmicros.com)

 For the IS471F Infrared Proximity Detector. Vo = PB7, green LED indicates
 proximity (On=Object, Off=No Object)

 Peter F Gray (petegray@ieee.org)
 2Feb03

---*/

#include "scdefs.h"

/* GPIO registers */
#define PEPUR   0x0FF0
#define PEDR    0x0FF1
#define PEDDR   0x0FF2
#define PEPER   0x0FF3
#define PEIAR   0x0FF4
#define PEIENR  0x0FF5
#define PEIPOLR 0x0FF6
#define PEIPR   0x0FF7
#define PEIESR  0x0FF8

#define PBPUR   0x0FC0
#define PBDR    0x0FC1
#define PBDDR   0x0FC2
#define PBPER   0x0FC3
#define PBIAR   0x0FC4
#define PBIENR  0x0FC5
#define PBIPOLR 0x0FC6
#define PBIPR   0x0FC7
#define PBIESR  0x0FC8

/* main program */
main ()
{
  int val;

  *PEIAR = 0;				/* set up GPIO */
  *PEIENR = 0;                          /* port E (LEDs) */
  *PEIPOLR = 0;
  *PEIESR = 0;
  *PEPER = 0x00F3;
  *PEDDR = 0x000C;
  *PEPUR = 0x00FF;

  *PBIAR = 0;                           /* port B (Vo) */
  *PBIENR = 0;                        
  *PBIPOLR = 0;
  *PBIESR = 0;
  *PBPER = 0;
  *PBDDR = 0;
  *PBPUR = 0;

  *PEDR |= 0x000C;                      /* turn green and yellow LED on */

  while (1) {                           /* loop forever */
    val = *PBDR;                        /* read Vo from IR */
    if ((val & 0x0080) == 0x0080)       /* true = no object */
      *PEDR &= 0x00F7;                  /* turn off green LED */
    else
      *PEDR |= 0x0008;                  /* turn on green LED */
  }

}
