/*+++

 mini1.c
 GPIO example program for the NMIN-0803-MINI (see http://www.newmicros.com)

 NMIN-0803-Mini test program - turns red LED on, flashes green LED.

 Peter F Gray (petegray@ieee.org)
 2Mar03

---*/

#include "scdefs.h"

/* GPIO registers */
#define PEPUR   0x0FF0
#define PEDR    0x0FF1
#define PEDDR   0x0FF2
#define PEPER   0x0FF3
#define PEIAR   0x0FF4
#define PEIENR  0x0FF5
#define PEIPOLR 0x0FF6
#define PEIPR   0x0FF7
#define PEIESR  0x0FF8

/* cause a pause */
delay ()
{
  unsigned int i;
  for (i=0; i<60000; i++);
}

/* main program */
main ()
{
  int val;

  *PEIAR = 0;                           /* set up GPIO        */
  *PEIENR = 0;
  *PEIPOLR = 0;
  *PEIESR = 0;
  *PEPER = 0x00F3;
  *PEDDR = 0x000C;
  *PEPUR = 0x00FF;
  val = 0x0004;
  *PEDR = val;                          /* set red LED on     */

  while (1) {                           /* loop forever       */
    delay();                            /* pause              */
    val |= 0x0008;                      /* turn green LED on  */
    *PEDR = val;                        /* and set lines      */
    delay();                            /* pause              */
    val &= 0x00F7;                      /* turn green LED off */
    *PEDR = val;                        /* and set lines      */
  }

}
