/*+++

 leds_b.c
 GPIO example program for the IsoPod (see http://www.newmicros.com)

 Allows the user to turn the yellow and green LEDs on and off
 via the PC (using hyperterm, minicom etc).
 NOTE: This is the Serial Bootloader version.

 Peter F Gray (petegray@ieee.org)
 14Feb03

---*/

#include "scdefs.h"

/* GPIO registers */
#define PEPUR   0x0FF0
#define PEDR    0x0FF1
#define PEDDR   0x0FF2
#define PEPER   0x0FF3
#define PEIAR   0x0FF4
#define PEIENR  0x0FF5
#define PEIPOLR 0x0FF6
#define PEIPR   0x0FF7
#define PEIESR  0x0FF8

/* SCI registers */
#define SCI0BR  0x0F00
#define SCI0CR  0x0F01
#define SCI0SR  0x0F02
#define SCI0DR  0x0F03

/* I/O routines for SCI (i.e. PC hyperterm or minicom communication) */
inscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0x3000)!=0x3000);
  *b = *a;
}

outsci (a,b)
int  *a;
unsigned char *b;
{
  unsigned int status;
  while (*b) {
    do status = *SCI0SR; while ((status&0xC000)!=0xC000);
    *a = *b;
    *b++;
  }
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

outscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
  *a = *b;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

/* main program */
main ()
{
  char c;
  int val;

  *SCI0BR = 22;                  /* set up SCI (115200, 8 Bits, No Parity) */
  *SCI0CR = 12;                  

  outsci (SCI0DR,"\15\nLED Test (Serial Bootloader version) ready.\15\n");
  outsci (SCI0DR,"1=Green ON, 2=Green OFF, 3=Yellow ON, 4=Yellow OFF\15\n");

  *PEIAR = 0;				/* set up GPIO */
  *PEIENR = 0;
  *PEIPOLR = 0;
  *PEIESR = 0;
  *PEPER = 0x00F3;
  *PEDDR = 0x000C;
  *PEPUR = 0x00FF;
  val = 0;
  *PEDR = val;				/* set to zero (i.e. 'off') */

  while (1) {				/* loop forever */
    inscichar (SCI0DR,&c);		/* input a character */
    if (c=='1') val |= 0x0008;		/* adjust lines according to input... */
    if (c=='2') val &= 0x00F7;
    if (c=='3') val |= 0x0004;
    if (c=='4') val &= 0x00FB;
    *PEDR = val;			/* and set lines */
  }

}
