/*+++

 GPIO example program for ServoPod (Iso807) (see http://www.newmicros.com)

 Allows the user to turn the red, yellow and green LEDs on and off
 via the PC (using hyperterm, minicom etc).

 Peter F Gray (petegray@ieee.org)
 5Jun03

---*/

#include "scdefs.h"

/* GPIO registers */
#define PDPUR   0x13E0
#define PDDR    0x13E1
#define PDDDR   0x13E2
#define PDPER   0x13E3
#define PDIAR   0x13E4
#define PDIENR  0x13E5
#define PDIPOLR 0x13E6
#define PDIPR   0x13E7
#define PDIESR  0x13E8

/* SCI registers */
#define SCI0BR  0x1300
#define SCI0CR  0x1301
#define SCI0SR  0x1302
#define SCI0DR  0x1303

/* I/O routines for SCI (i.e. PC hyperterm or minicom communication) */
inscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0x3000)!=0x3000);
  *b = *a;
}

outsci (a,b)
int  *a;
unsigned char *b;
{
  unsigned int status;
  while (*b) {
    do status = *SCI0SR; while ((status&0xC000)!=0xC000);
    *a = *b;
    *b++;
  }
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

/* main program */
main ()
{
  char c;
  int val;

  *SCI0BR = 260;			/* set up SCI (9600, 8 Bits, No Parity) */
  *SCI0CR = 12;				/* and display instructions... */

  outsci (SCI0DR,"\15\nSCI Module Ready\15\n");
  outsci (SCI0DR,"1/2=Red ON/OFF, 3/4=Yellow ON/OFF, 5/6=Green ON/OFF\15\n");

  *PDIAR = 0;                           /* set up GPIO */
  *PDIENR = 0;
  *PDIPOLR = 0;
  *PDIESR = 0;
  *PDPER = 0x00F8;
  *PDDDR = 0x0007;
  *PDPUR = 0x00FF;
  val = 0;
  *PDDR = val;                          /* set to zero (i.e. 'off') */

  while (1) {				/* loop forever */
    inscichar (SCI0DR,&c);		/* input a character */
    if (c=='1') val |= 0x0001;          /* adjust lines according to input... */
    if (c=='2') val &= 0x00FE;
    if (c=='3') val |= 0x0002;
    if (c=='4') val &= 0x00FD;
    if (c=='5') val |= 0x0004;
    if (c=='6') val &= 0x00FB;
    *PDDR = val;                        /* and set lines */
  }

}
