/*+++

 i2cprot.c
 I2C example program.
 Protocol level.

 Peter F Gray (petegray@ieee.org)
 24Jun03

---*/

#include "i2cprot.h"

//--------------------------------------------------------------------------
// Protocol Interface

// I2C send byte
i2c_snd_byte (mybyte)
int mybyte;
{
  int mask;

  mask = 0x0080;
  while (mask) {
    if (mybyte & mask)
      i2c_set_sda(1);
    else
      i2c_set_sda(0);
    i2c_clock();
    mask >>= 1;                         // shift right 1 bit
  }
  i2c_set_sda(1);                       // set data line high during ack
  return i2c_clock();                   // 0 is an ACK
}

// I2C receive byte
i2c_rcv_byte (ack)
int ack;
{
  int mybyte;
  int mask;

  mask = 0x0080;
  mybyte = 0;
  while (mask) {
    if (i2c_clock()) mybyte |= mask;
    mask >>= 1;
  }
  if (ack==I2CACK) {
    i2c_set_sda(0); i2c_clock(); i2c_set_sda(1);
  }
  else {
    i2c_set_sda(1); i2c_clock();
  }
  return mybyte;
}

// I2C start signal
i2c_start(slave,rw)
int  slave;
int  rw;
{
  i2c_set_sda(1);                       // set them both high, just in case
  i2c_set_scl(1);                       // we arrived here in the wrong state
  i2c_set_sda(0);                       // sda low
//  i2c_pause();                          // start/stop pause
  i2c_set_scl(0);                       // scl low
  if (rw==I2CREAD) slave |= 1;          // add rw bit, if specified
  return i2c_snd_byte(slave);           // 0 is an ACK
}

// I2C stop signal
i2c_stop()
{
  i2c_set_sda(0);                       // send the stop signal
  i2c_set_scl(1);
  i2c_pause();                          // pause
  i2c_set_sda(1);                       // sda high
}

