/*+++

 i2c807hw.c
 I2C example program for ServoPod (see http://www.newmicros.com)
 Hardware Interface Level.

 Performs I2C protocol communications via GPIO. PA0 = SDA, PA1 = SCL.
 LEDs are also set (Port D) to reflect the state of the I2C bus.

 Peter F Gray (petegray@ieee.org)
 24Jun03

---*/

#include "gpio807a.h"
#include "gpio807d.h"

//--------------------------------------------------------------------------
// Hardware interface

// I2C set the data line high or low
i2c_set_sda (v)
int v;
{
  if (v==1) {
    *PDDR |= 0x0001;
    *PADR |= 0x0001;
  }
  else {
    *PDDR &= 0x00FE;
    *PADR &= 0x00FE;
  }
}

// I2C set the clock line high or low
i2c_set_scl (v)
int v;
{
  if (v==1) {
    *PDDR |= 0x0002;
    *PADR |= 0x0002;
  }
  else {
    *PDDR &= 0x00FD;
    *PADR &= 0x00FD;
  }
}

// I2C init the bus
i2c_init()
{
  *PDDR |= 0x0003;                      // set both lines high
  *PADR |= 0x0003;
}

// I2C pause
i2c_pause()
{
  int i;
  for (i=0; i<25; i++);
}

// I2C clock a bit out, return the ack bit
i2c_clock()
{
  int   ack;
  i2c_set_scl(1);                       // clock high
  i2c_pause();
  *PADDR = 0x0002;                      // set PA0 for input
//  *PADDR &= 0x00FE;                      // set PA0 for input
  ack = (*PADR)&1;
  *PADDR = 0x0003;                      // set PA0 for output
//  *PADDR &= 0x00FF;                      // set PA0 for output
  i2c_set_scl(0);                       // clock low
  return ack;
}

