/*+++

 I2C example program for ServoPod (see http://www.newmicros.com)

 Performs I2C protocol communications via GPIO. PA0 = SDA, PA1 = SCL.
 LEDs are also set (Port D) to reflect the state of the I2C bus.

 ServoPod is the I2C Master, standard mode, 7-bit addressing.

 Peter F Gray (petegray@ieee.org)
 24Jun03

---*/

#include "scdefs.h"
#include "gpio807a.h"
#include "gpio807d.h"
#include "i2cprot.h"

// SCI registers
#define SCI0BR  0x1300
#define SCI0CR  0x1301
#define SCI0SR  0x1302
#define SCI0DR  0x1303

// I/O routines for SCI (i.e. PC hyperterm or minicom communication)
inscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0x3000)!=0x3000);
  *b = *a;
}

outsci (a,b)
int  *a;
unsigned char *b;
{
  unsigned int status;
  while (*b) {
    do status = *SCI0SR; while ((status&0xC000)!=0xC000);
    *a = *b;
    *b++;
  }
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

outscichar (a,b)
int  *a;
unsigned char b;
{
  int status;

  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
  *a = b;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

outscihex (a,b)
int *a;
int b;
{
  int  c,r,neg;
  char t[5];

  c = 3; neg = 0;
  if ((b&0x8000)==0x8000) {                   /* test for sign bit */
    neg = 1;
    b &= 0x7FFF;                              /* remove if found */
    }
  while (c>=0) { 
    r = b&0x000F;
    if (r < 10)
      t[c] = '0'+r;
    else
      t[c] = 'A'+((r)-10);
    b >>= 4;
    c--;
    if (neg&&(c==0)) b |= 0x0008;             /* put sign bit back */
  }
  t[4] = 0;
  outsci (a,t); 
}

//--------------------------------------------------------------------------
// main program

main ()
{
  char c;
  int   result, p;

  *SCI0BR = 260;                        // set up SCI (9600, 8N1)
  *SCI0CR = 12;                         // and display instructions...

  outsci (SCI0DR,"\15\nI2C Master, SCI Module Ready\15\n");

  *PAIAR = 0;                           // set up GPIO - port A
  *PAIENR = 0;
  *PAIPOLR = 0;
  *PAIESR = 0;
  *PAPER = 0x00FC;
  *PADDR = 0x0003;
  *PAPUR = 0x00FF;
  *PDIAR = 0;                           // set up GPIO - port D (LEDs)
  *PDIENR = 0;
  *PDIPOLR = 0;
  *PDIESR = 0;
  *PDPER = 0x00F8;                      // peripheral enable off
  *PDDDR = 0x0007;                      // configure for output
  *PDPUR = 0x00FF;                      // pull-ups enabled

  i2c_init();                           // init the I2C bus
  while (1) {                           // loop forever
    outsci (SCI0DR,"Press any key to continue\15\n");
    inscichar (SCI0DR,&c);              // wait for character input
    outsci (SCI0DR,"Start...\15\n");

//+++ Example - Reading the CMPS03 Compass (byte)

    if (i2c_start(0x00C0,I2CWRITE))
      outsci (SCI0DR,"No response\15\n");
    else
      if (i2c_snd_byte(1))
        outsci (SCI0DR,"No response to register request\15\n");
      else
        if (i2c_start(0x00C0,I2CREAD))
          outsci (SCI0DR,"No response read request\15\n");
        else {
          result = i2c_rcv_byte(I2CNOACK);
          outscihex (SCI0DR,result);
        }
    i2c_stop();

//---

//+++ Example - Reading the CMPS03 Compass (word)
/*
    if (i2c_start(0x00C0,I2CWRITE))
      outsci (SCI0DR,"No response\15\n");
    else
      if (i2c_snd_byte(1))
        outsci (SCI0DR,"No response to register request\15\n");
      else
        if (i2c_start(0x00C0,I2CREAD))
          outsci (SCI0DR,"No response read request\15\n");
        else {
          result = i2c_rcv_byte(I2CACK);
          outscihex (SCI0DR,result);
          result = i2c_rcv_byte(I2CNOACK);
          outscihex (SCI0DR,result);
        }
    i2c_stop();
*/
//---

    outsci (SCI0DR,"...End\15\n");
  }

}
