/*+++

 i2c805hw.c
 I2C example program for ServoPod (see http://www.newmicros.com)
 Hardware Interface Level.

 Performs I2C protocol communications via GPIO. PD0 = SDA, PD1 = SCL.
 LEDs are set (Port E) to reflect the state of the I2C bus.

 Peter F Gray (petegray@ieee.org)
 5Jul03

---*/

#include "gpio805d.h"

//--------------------------------------------------------------------------
// Hardware interface

// I2C set the data line high or low
i2c_set_sda (v)
int v;
{
  if (v==1) {
    *PDDR |= 0x0001;
    *PEDR |= 0x0008;
  }
  else {
    *PDDR &= 0x00FE;
    *PEDR &= 0x00F7;
  }
}

// I2C set the clock line high or low
i2c_set_scl (v)
int v;
{
  if (v==1) {
    *PDDR |= 0x0002;
    *PEDR |= 0x0004;
  }
  else {
    *PDDR &= 0x00FD;
    *PEDR &= 0x00FB;
  }
}

// I2C init the bus
i2c_init()
{
  *PDDR |= 0x0003;                      // set both lines high
  *PEDR |= 0x000C;                      // set both lines high
}

// I2C pause
i2c_pause()
{
  int i;
  for (i=0; i<25; i++);
}

// I2C clock a bit out, return the ack bit
i2c_clock()
{
  int   ack;
  i2c_set_scl(1);                       // clock high
  i2c_pause();
  *PDDDR = 0x0002;                      // set PD0 for input
//  *PADDR &= 0x00FE;                      // set PA0 for input
  ack = (*PDDR)&1;
  *PDDDR = 0x0003;                      // set PD0 for output
//  *PADDR &= 0x00FF;                      // set PA0 for output
  i2c_set_scl(0);                       // clock low
  return ack;
}

