/*+++

 GPIO example program for the IsoPod (see http://www.newmicros.com)

 I have a LED bar connected to the IO lines. The program will still
 function without the bar because the yellow and green LEDs on the
 IsoPod board are on the same port.

 The program "counts" and displays progress on the LED bar.

 Peter F Gray (petegray@ieee.org)
 9Jan03

---*/

#include "scdefs.h"

/* GPIO registers */
#define PAPUR   0x0FF0
#define PADR    0x0FF1
#define PADDR   0x0FF2
#define PAPER   0x0FF3
#define PAIAR   0x0FF4
#define PAIENR  0x0FF5
#define PAIPOLR 0x0FF6
#define PAIPR   0x0FF7
#define PAIESR  0x0FF8

/* function to cause a delay */
delay ()
{
  unsigned int d;
  for (d=0; d<10000; d++);
}

/* main program */
main ()
{
  unsigned int c;

  *PAIAR = 0;			/* set up the IO port ready for use */
  *PAIENR = 0;
  *PAIPOLR = 0;
  *PAIESR = 0;
  *PAPER = 0;
  *PADDR = 0xFFFF;

  c = 0;			/* start at zero */
  while (1) {			/* loop forever */
    *PADR = c;			/* load the output value */
    delay();			/* delay (the IsoPod is FAST!) */
    c++;			/* increment the output value */
    if (c>30000) c = 0;		/* and reset when it gets high */
  }

}