/*+++

 gp2d02.c
 Example program for the IsoPod (see http://www.newmicros.com)

 For the Sharp GP2D02 Infrared Ranger. Vin = PA7, Vout = PB7.

 Peter F Gray (petegray@ieee.org)
 8Feb03

---*/

#include "scdefs.h"

/* SCI definitions */
#define SCI0BR  0x0F00
#define SCI0CR  0x0F01
#define SCI0SR  0x0F02
#define SCI0DR  0x0F03

/* GPIO definitions */
#define PAPUR   0x0FB0
#define PADR    0x0FB1
#define PADDR   0x0FB2
#define PAPER   0x0FB3
#define PAIAR   0x0FB4
#define PAIENR  0x0FB5
#define PAIPOLR 0x0FB6
#define PAIPR   0x0FB7
#define PAIESR  0x0FB8

#define PBPUR   0x0FC0
#define PBDR    0x0FC1
#define PBDDR   0x0FC2
#define PBPER   0x0FC3
#define PBIAR   0x0FC4
#define PBIENR  0x0FC5
#define PBIPOLR 0x0FC6
#define PBIPR   0x0FC7
#define PBIESR  0x0FC8

/* SCI I/O routines */
outsci (a,b)
int  *a;
unsigned char *b;
{
  int status;
  while (*b) {
    do status = *SCI0SR; while ((status&0xC000)!=0xC000);
    *a = *b;
    *b++;
  }
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

outscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
  *a = *b;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

void outdec (chan, val)
unsigned int *chan;
unsigned int val;
{
  unsigned int u,t;
  unsigned char c;
  t = 10000;
  do {
    u = 0;
    while (val>=t) { val -= t; u++; }
    c = '0' + u;
    outscichar (chan,&c);
    t /= 10;
  } while (t>0);
}

delay ()
{
  unsigned int i;
  for (i=1; i<30000; i++);
}

/* main program */
main ()
{
  unsigned int val;
  unsigned int result;
  int c, d;
  *PAIAR = 0;                           /* port A (Vin) */
  *PAIENR = 0;                        
  *PAIPOLR = 0;
  *PAIESR = 0;
  *PAPER = 0;
  *PADDR = 0x0080;
  *PAPUR = 0;

  *PBIAR = 0;                           /* port B (Vout) */
  *PBIENR = 0;                        
  *PBIPOLR = 0;
  *PBIESR = 0;
  *PBPER = 0;
  *PBDDR = 0;
  *PBPUR = 0;

  *SCI0BR = 260;                        /* set up SCI */
  *SCI0CR = 12;                         /* 9600, N81 */

  outsci (SCI0DR,"\15\nSCI Module Ready.\15\n");
  
  while (1) {                           /* loop forever */
    *PADR = 0x0080;                     /* take Vin high */
    delay();
    do val = *PBDR;                     /* wait for Vout to go high */
      while ((val&0x0080)!=0x0080);
    *PADR = 0;                          /* take Vin low */
    delay();
    result = 0;
    do val = *PBDR;                     /* wait for Vout to go high */
      while ((val&0x0080)!=0x0080);
    for (c=7; c>=0; c--) {              /* start clocking, MSB to LSB */
      *PADR = 0x0080;                   /* take Vin high */
      for (d=1; d<50; d++);             /* keep high briefly */
      *PADR = 0;                        /* and low again */
      for (d=1; d<50; d++);             /* pause briefly */
      val = *PBDR;                      /* read Vout */
      if ((val&0x0080)==0x0080)
        result += (1 << c);             /* shift and add it to result */
    }
    outdec (SCI0DR,result);
    outsci (SCI0DR,"\15");
  }

}
