/*+++

 cmps01.c
 Example program for the IsoPod (see http://www.newmicros.com)

 Electronic compass (TC0 = PWM). Tested with Devantech CMPS03.

 Peter F Gray (petegray@ieee.org)
 12Feb03

---*/

#include "scdefs.h"

/* SCI definitions */
#define SCI0BR  0x0F00
#define SCI0CR  0x0F01
#define SCI0SR  0x0F02
#define SCI0DR  0x0F03

/* TIMER definitions */
#define D40 0x0D40
#define D41 0x0D41
#define D42 0x0D42
#define D43 0x0D43
#define D45 0x0D45
#define D46 0x0D46
#define D47 0x0D47

/* general purpose I/O routines */
outsci (a,b)
int  *a;
unsigned char *b;
{
  int status;
  while (*b) {
    do status = *SCI0SR; while ((status&0xC000)!=0xC000);
    *a = *b;
    *b++;
  }
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

outscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
  *a = *b;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

void outdec (chan, val)
unsigned int *chan;
unsigned int val;
{
  unsigned int u,t;
  unsigned char c;
  t = 10000;
  do {
    u = 0;
    while (val>=t) { val -= t; u++; }
    c = '0' + u;
    outscichar (chan,&c);
    t /= 10;
  } while (t>0);
}

main ()
{
  int result, status, degrees;

  *SCI0BR = 260;                             /* set up SCI */
  *SCI0CR = 12;                              /* 9600, N81 */

  outsci (SCI0DR,"\15\nSCI Module Ready.\15\n");

  while (1) {                                /* loop forever */
    *D40 = 0;                                /* TMRC0 CMP1 = 0 */
    *D41 = 0;                                /* TMRC0 CMP2 = 0 */
    *D43 = 0;                                /* TMRC0 LOAD = 0 */
    *D45 = 0;                                /* TMRC0 CNTR = 0 */
    *D46 = 0x7E00;                           /* CTRL rising prim, sec high */
    *D47 = 0x0080;                           /* SCR load rising edge */
                                             /* wait for result */
    do status = *D47; while ((status & 0x0100) != 0x0100);

    result = *D42;                           /* get capture value */
    outdec (SCI0DR,result);
    outsci (SCI0DR," = ");
                                        /* convert to degrees             */
                                        /* NOTE                           */
                                        /* range = maxval - minval        */
                                        /* f = range / 360                */
                                        /* degrees = (val - minval) / f   */

    degrees = (result-300) / ((6000-300)/360);

                                        /* Calibrate compass. Then use    */
                                        /* this program and move the      */
                                        /* compass to find minval and     */
                                        /* maxval (either side of North), */
                                        /* then substitute into the       */
                                        /* equation (above)               */
    outdec (SCI0DR,degrees);
    outsci (SCI0DR," deg.");
    outsci (SCI0DR," \15");

  }
}

