/*+++

 ADC example program for the IsoPod (see http://www.newmicros.com)

 Displays ADC reading, in decimal, taken from ANA0. Tested with
 Sharp GP2D12 Infrared sensor.

 Peter F Gray (petegray@ieee.org)
 28Jan03

---*/

#include "scdefs.h"

/* SCI definitions */
#define SCI0BR  0x0F00
#define SCI0CR  0x0F01
#define SCI0SR  0x0F02
#define SCI0DR  0x0F03

/* ADC definitions */
#define ADCR1      0x0E80
#define ADSDIS     0x0E85
#define ADSTAT     0x0E86
#define ADRSLT0    0x0E89

/* general purpose I/O routines */
outsci (a,b)
int  *a;
unsigned char *b;
{
  int status;
  while (*b) {
    do status = *SCI0SR; while ((status&0xC000)!=0xC000);
    *a = *b;
    *b++;
  }
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

outscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
  *a = *b;
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

void outdec (chan, val)
unsigned int *chan;
unsigned int val;
{
  unsigned int u,t;
  unsigned char c;
  t = 10000;
  do {
    u = 0;
    while (val>=t) { val -= t; u++; }
    c = '0' + u;
    outscichar (chan,&c);
    t /= 10;
  } while (t>0);
}

main ()
{
  int  stat, result, ave, count;

  *SCI0BR = 260;                                /* set up SCI */
  *SCI0CR = 12;                                 /* 9600, N81 */
  *ADSDIS = 254;                                /* enable channel zero */

  outsci (SCI0DR,"\15\nSCI Module Ready. ADC Enabled, reading ANA0.\15\n");

  count = ave = 0;
  while (1) {                                   /* loop forever */
    *ADCR1 = 0x2000;                            /* start conversion */
    do stat = *ADSTAT; while ((stat&1)!=1);     /* wait until complete */
    result = *ADRSLT0 >> 3;                     /* low 3 bits not used */
    ave += result >> 5;                         /* /32 and sum */
    count++;
    if (count==32) {
      outdec (SCI0DR,ave); outsci (SCI0DR," ave");
      count = ave = 0;
    }
    outsci (SCI0DR,"\15");
  }
}

