/*+++

 GPIO example program for Plug-a-Pod

 Allows the user to turn the red, yellow and green LEDs on and off
 via the PC (using hyperterm, nmiterm, minicom etc).

 Peter F Gray (petegray@ieee.org)
 13Jan03

---*/

#include "scdefs.h"

/* GPIO registers */
#define PAPUR   0x0FB0
#define PADR    0x0FB1
#define PADDR   0x0FB2
#define PAPER   0x0FB3
#define PAIAR   0x0FB4
#define PAIENR  0x0FB5
#define PAIPOLR 0x0FB6
#define PAIPR   0x0FB7
#define PAIESR  0x0FB8

/* SCI registers */
#define SCI0BR  0x0F00
#define SCI0CR  0x0F01
#define SCI0SR  0x0F02
#define SCI0DR  0x0F03

/* I/O routines for SCI (i.e. PC hyperterm or minicom communication) */
inscichar (a,b)
int  *a;
unsigned char *b;
{
  int status;
  do status = *SCI0SR; while ((status&0x3000)!=0x3000);
  *b = *a;
}

outsci (a,b)
int  *a;
unsigned char *b;
{
  unsigned int status;
  while (*b) {
    do status = *SCI0SR; while ((status&0xC000)!=0xC000);
    *a = *b;
    *b++;
  }
  do status = *SCI0SR; while ((status&0xC000)!=0xC000);
}

/* main program */
main ()
{
  char c;
  int val;

  *SCI0BR = 22;			/* set up SCI (115,200, 8 Bits, No Parity) */
  *SCI0CR = 12;				/* and display instructions... */

  outsci (SCI0DR,"\15\nSCI Module Ready\15\n");
  outsci (SCI0DR,"1/2=Red ON/OFF, 3/4=Green ON/OFF, 5/6=Yellow ON/OFF\15\n");

*PAIAR = 0; /* set up GPIO */
*PAIENR = 0;
*PAIPOLR = 0;
*PAIESR = 0;
*PAPER = 0x00F8;
*PADDR = 0x0007; /* PA0-2 config for outputs */ 
*PAPUR = 0x00FF;
val = 0;
*PADR = val; /* set to zero (i.e. 'off') */

while (1) { /* loop forever */
inscichar (SCI0DR,&c); /* input a character */
if (c=='1') val |= 0x0001; /* adjust lines according to input... */
if (c=='2') val &= 0x00FE;
if (c=='3') val |= 0x0002;
if (c=='4') val &= 0x00FD;
if (c=='5') val |= 0x0004;
if (c=='6') val &= 0x00FB;
*PADR = val; /* and set lines */
}

}
